﻿Imports System
Imports System.Drawing
Imports System.IO
Imports System.Drawing.Printing
Imports System.Windows.Forms
Imports System.Drawing.FontFamily


Public Class Form1
    Dim DirPath As String                    ' this is the directory path
    Dim SubjectNumber As String              ' this is the number of the computer machine that the subject uses
    Dim InputFileNumber As String            ' this is ther input file number
    Dim vs, hs As Integer                    ' these are for the vertical and horizontal scales
    Dim t, bt, s As Integer                  ' this is the time period
    Dim vg, hg As Integer                    ' these are the gaps between the little boxes
    Dim w0, h0, w1 As Integer                ' these are the starting positions of the instructions and the tree
    Dim wb, hb As Integer                    ' these are the width and height of the big box
    Dim BigBox As Label                      ' This is the big box
    Dim Box(20, 20) As Label                 ' These are the little boxes
    Dim CashFlowBox(20, 20) As Label         ' These are the cashflow boxes
    Dim ProbabilityBox(20, 20) As Label      ' These are the probability boxes
    Dim TopSmallBox(20, 20) As Integer       ' This is the top of the small box
    Dim HeightSmallBox As Integer            ' This is the height of the small box
    Dim X(20, 20) As Integer                 ' These are the cash flows
    Dim p(20, 20) As Double                  ' These are the probabilities
    Dim q As Single                          ' This is the binomial probability
    Dim h As Integer                         ' This is the increment
    Dim sgap As Integer                      ' This is the small gap between the cash flow box and the probability box
    Dim Instructions As Label               ' This is going to contain the instructions
    Dim InstructionsBeforeStart As Label     ' This is going to contain the instructions before the start of the experiment
    Dim StopButton, ContinueButton, ConfirmButton As Button ' These are the various buttons
    Dim ConfirmStartButton As Button         ' This is to confirm the start
    Dim WidthButton, HeightButton            'These are the widths and heights of the stop and continue buttons
    Dim StopDecision, ContinueDecision, ConfirmDecision As Integer ' These are to indicate the decision of the subject
    Dim pt, ps As Integer                    ' These are the current period and the state of the current period
    Dim stopp(20) As Integer                 ' These are the stopping periods in the various problems
    Dim value As Integer                     ' This is the value of the random variable
    Dim m As Integer                         'This number is subtracted from the maximum number of states in each time period when the cash flows move up
    Dim time As Integer
    Dim MinTD(20), MaxTD(20) As Integer
    Dim TimeLeft As Label
    Dim SecondsLeft As Integer
    Dim qval(20) As Single                    'these are the q values
    Dim hval(20), btval(20) As Integer        ' these are the h and bt values
    Dim icf(20) As Integer                    'these are the initial cash flows
    Dim pn, np As Integer                     'These are the problem number and the number of problems
    Dim numcl(1000) As Integer                 ' this is the number of clicks in a particular problem)
    Dim clicks(100, 100), times(100, 100) As Integer
    Dim cn As Integer                         'click number
    Dim TotalTime As Integer                  'Total time elapsed in seconds from start of experiment
    Dim EndOfProblem As Integer               'This takes the value 0 until the end of a problem and then takes the value 1
    Dim LV(20) As Integer                     'This is the liquidation value
    Dim Earnings(20) As Integer               'This is their earnings
    Dim CTvalue As String
    Dim DataInputBox As Label                 'This is to contain the data input
    Dim DataEnteredButton As Button           'This is to confirm the data entry
    Dim SubjectNumberLabel, InputFileNumberLabel As Label 'These are telling what to enter in the input data
    Dim SubjectNumberTextBox As TextBox       ' this is to contain the subject number
    Dim InputFileNumberTextBox As TextBox     'this is to contain the input file number
    Dim EndStart As Integer                   'this takes the value 0 until we are ready to start and then takes the value 1
    Dim Information As Label                  'this contains information to the subjects
    Dim Information2 As Label                 'this contains infromation about the stopping (disinvestment) value at the current period
    Dim rr(20) As Single                      'this is the interest rate of return
    Dim CurrentCF(20, 20) As Integer          'these are the current cash flows
    Dim ExecImage As New Label                'this is the EXEC logo
    Dim docName As String
    Dim docPath As String
    Dim OutputFile As String
    Dim k, kfinalcashflow, kindicator As Integer
    Dim button1 As Button
    Dim NaturesMoves(20, 20) As Integer        'this records natures moves
    Dim NextCashFlow(20, 20) As Integer         'this records the next cash flow




    Private Sub BuildInputDataBox()
        EXECLogo.Visible = False
        DataEnteredButton = New Button
        DataEnteredButton.Left = 2 * hs
        DataEnteredButton.Top = 7 * vs
        DataEnteredButton.Width = 6 * hs
        DataEnteredButton.Height = vs
        Me.DataEnteredButton.Font = New System.Drawing.Font("", 0.22 * hs)
        Me.Controls.Add(DataEnteredButton)
        DataEnteredButton.Visible = True
        AddHandler DataEnteredButton.Click, AddressOf DataEntered
        'this is a key line to make the Click on DataEntered work - it calls the routine DataEntered below
        DataEnteredButton.Text = "Click to Confirm"

        'creating and positioning DataInputBox Label
        DataInputBox = New Label
        DataInputBox.Width = 8 * hs
        DataInputBox.Height = 8 * vs
        DataInputBox.Left = hs
        DataInputBox.Top = vs
        Me.DataInputBox.Font = New System.Drawing.Font("", 0.25 * hs)
        DataInputBox.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(DataInputBox)
        DataInputBox.Visible = False
        DataInputBox.ForeColor = Color.Blue
        DataInputBox.Text = "Enter the subject number and input data file here"

        'creating and positioningSubjectNumberLabel
        SubjectNumberLabel = New Label
        SubjectNumberLabel.Width = 3 * hs
        SubjectNumberLabel.Height = 2 * vs
        SubjectNumberLabel.Left = 2 * hs
        SubjectNumberLabel.Top = 2 * vs
        Me.SubjectNumberLabel.Font = New System.Drawing.Font("", 0.22 * hs)
        Me.Controls.Add(SubjectNumberLabel)
        SubjectNumberLabel.Visible = True
        SubjectNumberLabel.ForeColor = Color.Blue
        SubjectNumberLabel.Text = "subject number"

        'creating and positioningSubjectNumberTextBox
        SubjectNumberTextBox = New TextBox
        SubjectNumberTextBox.Width = 2 * hs
        SubjectNumberTextBox.Height = 2 * vs
        SubjectNumberTextBox.Left = 5 * hs
        SubjectNumberTextBox.Top = 2 * vs
        Me.SubjectNumberTextBox.Font = New System.Drawing.Font("", 0.22 * hs)
        Me.Controls.Add(SubjectNumberTextBox)
        SubjectNumberTextBox.Visible = True
        SubjectNumberTextBox.ForeColor = Color.Blue
        SubjectNumberTextBox.Text = "1"


        'creating and positioning InputFileNumberLabel
        InputFileNumberLabel = New Label
        InputFileNumberLabel.Width = 3 * hs
        InputFileNumberLabel.Height = 2 * vs
        InputFileNumberLabel.Left = 2 * hs
        InputFileNumberLabel.Top = 4 * vs
        Me.InputFileNumberLabel.Font = New System.Drawing.Font("", 0.22 * hs)
        Me.Controls.Add(InputFileNumberLabel)
        InputFileNumberLabel.Visible = True
        InputFileNumberLabel.ForeColor = Color.Blue
        InputFileNumberLabel.Text = "input file number"

        'creating and positioningInputFileNumberTextBox
        InputFileNumberTextBox = New TextBox
        InputFileNumberTextBox.Width = 2 * hs
        InputFileNumberTextBox.Height = 2 * vs
        InputFileNumberTextBox.Left = 5 * hs
        InputFileNumberTextBox.Top = 4 * vs
        Me.InputFileNumberTextBox.Font = New System.Drawing.Font("", 0.22 * hs)
        Me.Controls.Add(InputFileNumberTextBox)
        InputFileNumberTextBox.Visible = True
        InputFileNumberTextBox.ForeColor = Color.Blue
        InputFileNumberTextBox.Text = "1"
        ControlExperiment.Enabled = True

    End Sub
    Private Sub BuildTree()
        Dim bbl, bbt, bbh As Integer
        bbl = 0.61 * w1   'changed 27/5/2014
        'bbl = 0.73 * w1
        bbt = h0
        bbh = hb

        'EXECLogo.Visible = False

        'creating and positioning Information Label
        Information = New Label
        Information.Width = 0.355 * wb
        Information.Height = 3.1 * vs
        Information.Left = 1.01 * bbl
        Information.Top = bbt * 2.0
        Me.Information.Font = New System.Drawing.Font("", 0.005 * hs * vs)
        Information.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(Information)
        Information.Visible = False
        Information.ForeColor = Color.Blue
        Information.Text = "Information"

        'creating and positioning Information2 Label
        Information2 = New Label
        Information2.Width = 0.355 * wb
        Information2.Height = 2.5 * vs
        Information2.Left = 1.01 * bbl
        Information2.Top = 0.875 * (h0 + hb)
        Me.Information2.Font = New System.Drawing.Font("", 0.005 * hs * vs)
        Information2.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(Information2)
        Information2.Visible = False
        Information2.ForeColor = Color.Blue
        Information2.Text = "Information2"

        'creating and positioning TimeLeft Label
        TimeLeft = New Label
        TimeLeft.Width = 0.25 * wb
        TimeLeft.Height = 0.06 * hb
        TimeLeft.Left = w1 + 3.4 * hs
        'w1 + 5.0 * hs   'was +0.075*hs
        TimeLeft.Top = 0.935 * (h0 + hb)
        Me.TimeLeft.Font = New System.Drawing.Font("", 0.25 * hs)
        TimeLeft.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(TimeLeft)
        TimeLeft.Visible = True
        TimeLeft.ForeColor = Color.Blue
        TimeLeft.Text = CStr(MaxTD(pn)) + " seconds left"

        'first defining the top and the heights of the small boxes
        HeightSmallBox = (hb - (bt + 2) * vg) / bt
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                TopSmallBox(t, s) = h0 + (HeightSmallBox * (bt - t)) / 2 + (s - 1) * HeightSmallBox + (s - 0.5) * vg
                s = s + 1
            Loop
            t = t + 1
        Loop

        'the cash flow boxes
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                CashFlowBox(t, s) = New Label
                CashFlowBox(t, s).Width = (wb - (bt + 2) * hg) / (1.04 * bt)
                CashFlowBox(t, s).Height = (HeightSmallBox - 7 * sgap) / 2
                CashFlowBox(t, s).Left = 1.1 * bbl + t * hg + (t - 1) * (CashFlowBox(t, s).Width) + hg
                CashFlowBox(t, s).Top = TopSmallBox(t, s) + 3 * sgap
                Me.CashFlowBox(t, s).Font = New System.Drawing.Font("", 120 / bt)
                CashFlowBox(t, s).BorderStyle = BorderStyle.FixedSingle
                Me.Controls.Add(CashFlowBox(t, s))
                CashFlowBox(t, s).Visible = True
                CashFlowBox(t, s).ForeColor = Color.Red
                s = s + 1
            Loop
            t = t + 1
        Loop

        'the probability boxes
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                ProbabilityBox(t, s) = New Label
                ProbabilityBox(t, s).Width = CashFlowBox(t, s).Width
                ProbabilityBox(t, s).Height = CashFlowBox(t, s).Height
                ProbabilityBox(t, s).Left = 1.1 * bbl + t * hg + (t - 1) * (ProbabilityBox(t, s).Width) + hg
                ProbabilityBox(t, s).Top = TopSmallBox(t, s) + 4 * sgap + CashFlowBox(t, s).Height
                Me.ProbabilityBox(t, s).Font = New System.Drawing.Font("", 100 / bt)
                ProbabilityBox(t, s).BorderStyle = BorderStyle.FixedSingle
                Me.Controls.Add(ProbabilityBox(t, s))
                If t > 1 Then ProbabilityBox(t, s).Visible = True
                If t = 1 Then ProbabilityBox(t, s).Visible = False
                ProbabilityBox(t, s).ForeColor = Color.Blue
                s = s + 1
            Loop
            t = t + 1
        Loop
        'now for the little boxes
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                Box(t, s) = New Label
                Box(t, s).Width = (wb - (bt + 2) * hg) / bt
                Box(t, s).Height = (hb - (bt + 2) * vg) / bt
                Box(t, s).Left = 1.1 * bbl + t * hg + (t - 1) * (Box(t, s).Width) + hg
                Box(t, s).Top = h0 + ((Box(t, s).Height) * (bt - t)) / 2 + (s - 1) * (Box(t, s).Height) + (s - 0.5) * vg
                Me.Box(t, s).Font = New System.Drawing.Font("", 0.13 * hs)
                Me.Controls.Add(Box(t, s))
                Box(t, s).Visible = False
                s = s + 1
            Loop
            t = t + 1
        Loop


        'now for the big box
        'MsgBox("hb is " + CStr(hb))
        BigBox = New Label
        BigBox.Left = bbl
        BigBox.Top = h0
        BigBox.Width = 1.04 * wb    'changed 27/5/2014
        'BigBox.Width = 1.04 * wb
        BigBox.Height = hb
        Me.BigBox.Font = New System.Drawing.Font("", 0.25 * hs)
        BigBox.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(BigBox)
        BigBox.Visible = True
        BigBox.Text = "Cash Flows and Probabilities"
    End Sub

    Private Sub CalculateCashFlows()
        t = 2
        Do While t <= bt
            s = 1
            Do While s <= t
                If s = 1 Then
                    X(t, 1) = X(t - 1, 1) + h
                Else
                    X(t, s) = X(t, s - 1) - 2 * h
                End If
                s = s + 1
            Loop
            t = t + 1
        Loop
    End Sub

    Private Sub CalculateProbabilities()   ' see document tree.docx in documentation folder this is replacing the old one which was, I think, wrong.
        Dim lt, ls As Integer                'local t and s
        p(pt, ps) = 1
        lt = pt + 1
        Do While lt <= bt
            p(lt, ps) = p(lt - 1, ps) * q 'going up
            If ((lt >= pt + 2) And (pt < bt - 1)) Then
                ls = ps + 1
                Do While ls <= ps + lt - pt - 1
                    p(lt, ls) = p(lt - 1, ls - 1) * (1 - q) + p(lt - 1, ls) * q   'going "across"
                    ls = ls + 1
                Loop
            End If
            p(lt, ps + lt - pt) = p(lt - 1, ps + lt - pt - 1) * (1 - q) 'going down
            lt = lt + 1
        Loop
    End Sub

    Private Sub Confirm()
        Dim lt, ls As Integer

        If EndOfProblem = 1 Then
            Information.Visible = False
            Information2.Visible = False
            ConfirmButton.Visible = False
            cn = cn + 1
            clicks(pn, cn) = 4
            numcl(pn) = cn
            times(pn, cn) = TotalTime
            pn = pn + 1
            If pn <= np Then RunProblem()
            If pn > np Then
                Instructions.Text = "Please alert the experimenter"
                EndExperiment()
            End If
            StopDecision = 0
            ContinueDecision = 0
            ConfirmDecision = 0
        End If

        If EndOfProblem = 0 Then
            Information.Visible = True
            Information2.Visible = True
            Timer.Enabled = True
            ConfirmButton.Text = "Click to confirm"
            cn = cn + 1
            clicks(pn, cn) = 3
            numcl(pn) = cn
            times(pn, cn) = TotalTime
            SecondsLeft = MaxTD(pn)
            ContinueButton.Visible = False
            StopButton.Visible = False
            ConfirmButton.Visible = False
            TimeLeft.Text = CStr(SecondsLeft) + " seconds left"

            'stopping
            If StopDecision = 1 And ContinueDecision = 0 Then
                Information.Visible = False
                Information2.Visible = False
                TimeLeft.Visible = False
                Timer.Enabled = False
                ConfirmButton.Visible = True
                If pn = np Then
                    Instructions.Visible = False
                    stopp(pn) = pt
                End If
                DeleteBox()
                If pn < np Then
                    stopp(pn) = pt
                    Information.Visible = False
                    Information2.Visible = False
                    Earnings(pn) = CStr(CurrentCF(pt, ps) + (Math.Round(LV(pn) * (rr(pn) ^ (bt - pt)))))
                    If Earnings(pn) >= 0 Then ConfirmButton.Text = "Your payoff was " + CStr(Earnings(pn)) + " pence on that problem. Please click to move onto the next."
                    If Earnings(pn) < 0 Then ConfirmButton.Text = "Your payoff was MINUS " + CStr(-1 * Earnings(pn)) + " pence on that problem. Please click to move onto the next."
                    EndOfProblem = 1
                End If
                If pn = np Then
                    stopp(pn) = pt
                    Information.Visible = False
                    Information2.Visible = False
                    cn = cn + 1
                    clicks(pn, cn) = 4
                    numcl(pn) = cn
                    times(pn, cn) = TotalTime
                    Instructions.Visible = False
                    ConfirmButton.Enabled = True
                    ConfirmButton.Visible = True
                    ' PrintFile()
                    Instructions.Text = "Please alert the experimenter"

                    Earnings(pn) = CStr(CurrentCF(pt, ps) + (Math.Round(LV(pn) * (rr(pn) ^ (bt - pt)))))
                    If Earnings(pn) >= 0 Then ConfirmButton.Text = "Your payoff was " + CStr(Earnings(pn)) + " pence on that final problem. The experiment is now over."
                    If Earnings(pn) < 0 Then ConfirmButton.Text = "You payoff was MINUS " + CStr(-1 * Earnings(pn)) + " pence on that final problem. The experiment is now over."
                    EndExperiment()
                End If
            End If

            'continuing

            If StopDecision = 0 And ContinueDecision = 1 Then
                'get rid of the present cash flow and probability boxes
                CashFlowBox(pt, ps).Visible = False
                ProbabilityBox(pt, ps).Visible = False
                pt = pt + 1
                If pt < bt Then
                    SecondsLeft = MaxTD(pn)
                    value = Int(Rnd() * 100) + 1

                    'going up
                    If value <= (q * 100) Then
                        NaturesMoves(pn, pt) = 1    'UP
                        CurrentCF(pt, ps) = CStr(CurrentCF(pt - 1, ps) + X(pt, ps))
                        NextCashFlow(pn, pt) = X(pt, ps)
                        If pt = bt - 1 Then
                            kindicator = 1 'up
                            k = CStr(CurrentCF(pt + 1, ps) + X(pt + 1, ps))
                            kfinalcashflow = CInt(X(pt + 1, ps))
                        End If
                        Information2.Text = "Nature has chosen to move UP. The cash flow in this period is " + CashFlowBox(pt, ps).Text + ". This is period " + CStr(pt) + "."
                        Information.Text = "If you dispose of the asset now, the value of the disposal will be " + CStr(Math.Round(LV(pn) * (rr(pn) ^ (bt - pt)))) + " points. The cash flows that you have gained until now are equal to " + CStr(CurrentCF(pt, ps)) + " points."
                        ProbabilityBox(pt, ps).Visible = False
                        CalculateProbabilities()
                        lt = pt + 1
                        Do While lt <= bt
                            ls = ps
                            Do While ls <= ps + lt - pt
                                ProbabilityBox(lt, ls).Text = CStr(Math.Round(p(lt, ls), 4))
                                ls = ls + 1
                            Loop
                            lt = lt + 1
                        Loop
                        lt = pt
                        ls = ps + 1
                        CashFlowBox(pt, ps + 1).Visible = False
                        ProbabilityBox(pt, ps + 1).Visible = False
                        Do While lt <= bt
                            CashFlowBox(lt, ls).Visible = False
                            ProbabilityBox(lt, ls).Visible = False
                            ls = ls + 1
                            lt = lt + 1
                        Loop
                    End If

                    'going down				
                    If value > (q * 100) Then
                        NaturesMoves(pn, pt) = 2    'DOWN
                        CurrentCF(pt, ps + 1) = CStr(CurrentCF(pt - 1, ps) + X(pt, ps + 1))
                        NextCashFlow(pn, pt) = X(pt, ps + 1)
                        If pt = bt - 1 Then
                            kindicator = 2 'down
                            k = CStr(CurrentCF(pt, ps + 1) + X(pt + 1, ps + 1))
                            kfinalcashflow = CInt(X(pt + 1, ps + 1))
                        End If
                        Information2.Text = "Nature has chosen to move DOWN. The cash flow in this period is " + CashFlowBox(pt, ps + 1).Text + ". This is period " + CStr(pt) + "."
                        Information.Text = "If you dispose of the asset now, the value of the disposal will be " + CStr(Math.Round(LV(pn) * (rr(pn) ^ (bt - pt)))) + " points. The cash flows that you have gained until now are equal to " + CStr(CurrentCF(pt, ps + 1)) + " points."
                        ps = ps + 1
                        ProbabilityBox(pt, ps).Visible = False
                        CalculateProbabilities()
                        lt = pt + 1
                        Do While lt <= bt
                            ls = ps
                            Do While ls <= ps + lt - pt
                                ProbabilityBox(lt, ls).Text = CStr(Math.Round(p(lt, ls), 4))
                                ls = ls + 1
                            Loop
                            lt = lt + 1
                        Loop
                        lt = pt + 1
                        CashFlowBox(pt, ps - 1).Visible = False
                        ProbabilityBox(pt, ps - 1).Visible = False
                        Do While lt <= bt
                            ProbabilityBox(lt, ps - 1).Visible = False
                            CashFlowBox(lt, ps - 1).Visible = False
                            lt = lt + 1
                        Loop
                    End If

                End If

                If pt = bt Then
                    'here is some material to decide the final move
                    value = Int(Rnd() * 100) + 1
                    If value <= (q * 100) Then
                        CurrentCF(pt, ps) = CStr(CurrentCF(pt - 1, ps) + X(pt, ps))
                        k = CStr(CurrentCF(pt, ps))
                        NaturesMoves(pn, pt) = 1    'UP
                        NextCashFlow(pn, pt) = X(pt, ps)
                        kindicator = 1 'up
                        kfinalcashflow = CInt(NextCashFlow(pn, pt))
                        Earnings(pn) = k + LV(pn)
                    End If
                    If value > (q * 100) Then
                        CurrentCF(pt, ps + 1) = CStr(CurrentCF(pt - 1, ps) + X(pt, ps + 1))
                        k = CStr(CurrentCF(pt, ps + 1))
                        NaturesMoves(pn, pt) = 2    'DOWN
                        NextCashFlow(pn, pt) = X(pt, ps + 1)
                        kindicator = 2 'down
                        kfinalcashflow = CInt(NextCashFlow(pn, pt))
                        Earnings(pn) = k + LV(pn)
                    End If


                    Information.Visible = False
                    Information2.Visible = False
                    TimeLeft.Visible = False
                    Timer.Enabled = False
                    ConfirmButton.Visible = True
                    If pn = np Then Instructions.Visible = False
                    stopp(pn) = pt
                    DeleteBox()
                    If pn < np Then
                        Earnings(pn) = CStr(k + (Math.Round(LV(pn) * (rr(pn) ^ (bt - pt)))))
                        If kindicator = 1 Then
                            If Earnings(pn) >= 0 Then ConfirmButton.Text = "Nature moved UP, the final cash flow was " + CStr(kfinalcashflow) + ". Your payoff was " + CStr(Earnings(pn)) + " on that problem. Please click to move onto the next."
                            If Earnings(pn) < 0 Then ConfirmButton.Text = "Nature moved UP, the final cash flow was " + CStr(kfinalcashflow) + ". Your payoff was MINUS " + CStr(-1 * Earnings(pn)) + " on that problem. Please click to move onto the next."
                        End If
                        If kindicator = 2 Then
                            If Earnings(pn) >= 0 Then ConfirmButton.Text = "Nature moved DOWN, the final cash flow was " + CStr(kfinalcashflow) + ". Your payoff was " + CStr(Earnings(pn)) + " on that problem. Please click to move onto the next."
                            If Earnings(pn) < 0 Then ConfirmButton.Text = "Nature moved DOWN, the final cash flow was " + CStr(kfinalcashflow) + ". Your payoff was MINUS " + CStr(-1 * Earnings(pn)) + " on that problem. Please click to move onto the next."
                        End If
                        EndOfProblem = 1
                    End If
                    If pn = np Then
                        Instructions.Text = "Please alert the experimenter"
                        ConfirmButton.Enabled = False
                        Earnings(pn) = CStr(k + (Math.Round(LV(pn) * (rr(pn) ^ (bt - pt)))))
                        If kindicator = 1 Then
                            If Earnings(pn) >= 0 Then ConfirmButton.Text = "Nature moved UP, the final cash flow was" + CStr(k) + ". Your payoff was " + CStr(Earnings(pn)) + " on this final problem. Please click to move onto the next."
                            If Earnings(pn) < 0 Then ConfirmButton.Text = "Nature moved UP, the final cash flow was" + CStr(k) + " Your payoff was MINUS " + CStr(-1 * Earnings(pn)) + " on this final problem. Please click to move onto the next."
                        End If
                        If kindicator = 2 Then
                            If Earnings(pn) >= 0 Then ConfirmButton.Text = "Nature moved DOWN, the final cash flow was" + CStr(k) + ". Your payoff was " + CStr(Earnings(pn)) + " on this final problem. Please click to move onto the next."
                            If Earnings(pn) < 0 Then ConfirmButton.Text = "Nature moved DOWN, the final cash flow was" + CStr(k) + "Your payoff was MINUS " + CStr(-1 * Earnings(pn)) + " on this final problem. Please click to move onto the next."
                        End If
                        EndExperiment()
                    End If
                End If
            End If
        End If
    End Sub
    Private Sub ConfirmStart()
        InstructionsBeforeStart.Visible = False
        ConfirmStartButton.Visible = False
        EndStart = 1
        RunProblem()
        Information.Visible = True
        Information2.Visible = True
    End Sub
    Private Sub ContinueProblem()
        ConfirmDecision = 0
        cn = cn + 1
        numcl(pn) = cn
        clicks(pn, cn) = 1
        times(pn, cn) = TotalTime
        ConfirmButton.Visible = True
        ContinueDecision = 1
        StopDecision = 0
    End Sub

    Private Sub ControlExperiment_Tick(sender As Object, e As EventArgs) Handles ControlExperiment.Tick
        ReadControlExperimentTime()
        If CTvalue = "1" Then
            Me.WindowState = FormWindowState.Maximized
            ControlExperiment.Enabled = False
            DataInputBox.Visible = False
            SubjectNumberLabel.Visible = False
            SubjectNumberTextBox.Visible = False
            InputFileNumberLabel.Visible = False
            InputFileNumberTextBox.Visible = False
            DataEnteredButton.Visible = False
            ' EXECLogo.Visible = False
            TotalTimer.Enabled = True
            TotalTime = 0
            SetParameters()
            ReadProblems()
            'Readvsandhs()
            'MsgBox("vs and hs are " + CStr(vs) + " " + CStr(hs))
            pn = 1
            EndOfProblem = 0
            RunProblem()
            ExecImage.Visible = False
            Instructions.Visible = True
            BigBox.Visible = False
            DeleteBox()

            'InstructionsBeforeStart.Visible = True
        End If
    End Sub
    Private Sub DataEntered()
        SubjectNumber = SubjectNumberTextBox.Text
        InputFileNumber = InputFileNumberTextBox.Text
        DataInputBox.Visible = False
        SubjectNumberLabel.Visible = False
        SubjectNumberTextBox.Visible = False
        InputFileNumberLabel.Visible = False
        InputFileNumberTextBox.Visible = False
        DataEnteredButton.Visible = False
        DisplayImage()
        Randomize(CInt(SubjectNumber))
    End Sub
    Private Sub DeleteBox()
            BigBox.Visible = False
            TimeLeft.Visible = False
            t = 1
            Do While t <= bt
                s = 1
                Do While s <= t
                    ProbabilityBox(t, s).Visible = False
                    Box(t, s).Visible = False
                    CashFlowBox(t, s).Visible = False
                    s = s + 1
                Loop
                t = t + 1
            Loop
            Instructions.Visible = False
    End Sub
    Private Sub DisplayImage()
        Dim EXEC As Image
        Dim ImageFile As String
        ImageFile = DirPath + "\pictures of exec\exec logo full.jpg"
        EXEC = Image.FromFile(ImageFile)
        ExecImage.Left = w0 * 4.5
        ExecImage.Top = h0 * 3.7
        ExecImage.Width = 5 * wb
        ExecImage.Height = 6.5 * hb
        ExecImage.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(ExecImage)
        ExecImage.Size = EXEC.Size
        ExecImage.Image = EXEC
        ExecImage.Visible = True
    End Sub
    Private Sub EndExperiment()
        Instructions.Left = 0
        Instructions.Top = 0
        Instructions.Width = 0
        Instructions.Height = 0
        WriteOutput()
        MsgBox("All Over! Please call over an experimenter.")
        ConfirmButton.Visible = False
        Instructions.Visible = False
        DisplayImage()
        PrintFile()
    End Sub

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        DirPath = Application.StartupPath
        Me.WindowState = FormWindowState.Maximized
        EndStart = 0
        StartExperiment()
        ControlBox = False
        SubjectNumber = "1"
        InputFileNumber = "1"
    End Sub

    Private Sub InsertButtons()
        StopButton = New Button
        StopButton.Width = 0.2 * wb
        StopButton.Left = (BigBox.Left + BigBox.Width) - StopButton.Width
        StopButton.Top = 1.005 * (BigBox.Top + BigBox.Height)
        StopButton.Height = 0.1 * hb
        Me.StopButton.Font = New System.Drawing.Font("", 0.25 * hs)
        Me.Controls.Add(StopButton)
        StopButton.Visible = False
        AddHandler StopButton.Click, AddressOf StopProblem
        'this is a key line to make the Click on Stop work - it calls the routine Stop below
        StopButton.Text = "Stop"

        ContinueButton = New Button
        ContinueButton.Left = BigBox.Left
        ContinueButton.Top = 1.005 * (BigBox.Top + BigBox.Height)
        ContinueButton.Width = 0.2 * wb
        ContinueButton.Height = 0.1 * hb
        Me.ContinueButton.Font = New System.Drawing.Font("", 0.25 * hs)
        Me.Controls.Add(ContinueButton)
        ContinueButton.Visible = False
        AddHandler ContinueButton.Click, AddressOf ContinueProblem
        'this is a key line to make the Click on continue work - it calls the routine continueproblem below
        ContinueButton.Text = "Continue"

        ConfirmButton = New Button
        'ConfirmButton.Left = 0.85 * w1 + ContinueButton.Width + (BigBox.Width - 4 * ContinueButton.Width) / 2
        ConfirmButton.Left = ContinueButton.Left + ContinueButton.Width
        ConfirmButton.Top = 1.01 * (StopButton.Top + StopButton.Height)
        'ConfirmButton.Width = 0.4 * wb
        ConfirmButton.Width = StopButton.Left - (ContinueButton.Left + ContinueButton.Width)
        ConfirmButton.Height = 0.1 * hb
        Me.ConfirmButton.Font = New System.Drawing.Font("", 0.006 * hs * vs)
        Me.Controls.Add(ConfirmButton)
        ConfirmButton.Visible = False
        AddHandler ConfirmButton.Click, AddressOf Confirm
        'this is a key line to make the Click on Confirm work - it calls the routine Confirm below
        ConfirmButton.Text = "Click to Confirm"

        ConfirmStartButton = New Button
        ConfirmStartButton.Left = ContinueButton.Left + ContinueButton.Width
        ConfirmStartButton.Top = 1.01 * (StopButton.Top + StopButton.Height)
        ConfirmStartButton.Width = StopButton.Left - (ContinueButton.Left + ContinueButton.Width)
        ConfirmStartButton.Height = 0.1 * hb
        Me.ConfirmStartButton.Font = New System.Drawing.Font("", 0.006 * hs * vs)
        Me.Controls.Add(ConfirmStartButton)
        ConfirmStartButton.Visible = False
        AddHandler ConfirmStartButton.Click, AddressOf ConfirmStart
        'this is a key line to make the Click on Confirm work - it calls the routine Confirm below
        ConfirmStartButton.Text = "Click when you are ready to start"

    End Sub

    Private Sub InsertCashFlows()
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                CashFlowBox(t, s).Text = CStr(X(t, s))
                s = s + 1
            Loop
            t = t + 1
        Loop
    End Sub

    Private Sub InsertProbabilities()
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                s = s + 1
            Loop
            t = t + 1
        Loop
    End Sub

    Private Sub MakeBordersOfSmallBoxesVisible()
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                Box(t, s).BorderStyle = BorderStyle.FixedSingle
                s = s + 1
            Loop
            t = t + 1
        Loop
    End Sub
       Private Sub ReadControlExperimentTime()
        Dim ControlExperimentPath As String
        Dim currentField As String
        Dim lpn As Integer
        ControlExperimentPath = DirPath + "\controlexperiment\controlexperiment.txt"
        Using ControlExperimentReader As New Microsoft.VisualBasic.FileIO.TextFieldParser(ControlExperimentPath)
            ControlExperimentReader.TextFieldType = FileIO.FieldType.Delimited
            ControlExperimentReader.SetDelimiters(" ")
            Dim currentRow As String()
            lpn = 1
            While Not ControlExperimentReader.EndOfData
                currentRow = ControlExperimentReader.ReadFields()
                For Each currentField In currentRow
                    CTvalue = currentField
                Next
                lpn = lpn + 1
            End While
        End Using
    End Sub

    Private Sub Readvsandhs()
        Dim vsandhsPath As String
        Dim lrn As Integer
        vsandhsPath = DirPath + "\controlexperiment\vsandhs.txt"
        Using vsandhsReader As New Microsoft.VisualBasic.FileIO.TextFieldParser(vsandhsPath)
            vsandhsReader.TextFieldType = FileIO.FieldType.Delimited
            vsandhsReader.SetDelimiters(" ")
            Dim currentRow As String()
            currentRow = vsandhsReader.ReadFields()
            Dim currentField As String
            lrn = 1
            For Each currentField In currentRow
                If lrn = 1 Then vs = CInt(currentField)
                If lrn = 2 Then hs = CInt(currentField)
                lrn = lrn + 1
            Next
        End Using
        'MsgBox("vs and hs are " + CStr(vs) + " " + CStr(hs))
    End Sub


    Private Sub ReadProblems()
        Dim ProblemsPath As String
        Dim lpn, lrn As Integer
        ProblemsPath = DirPath + "\input data\problems" + CStr(InputFileNumber) + ".txt"
        lpn = 2
        Using ProblemsReader As New Microsoft.VisualBasic.FileIO.TextFieldParser(ProblemsPath)
            ProblemsReader.TextFieldType = FileIO.FieldType.Delimited
            ProblemsReader.SetDelimiters(" ")
            Dim currentRow As String()
            lpn = 1
            While Not ProblemsReader.EndOfData
                currentRow = ProblemsReader.ReadFields()
                Dim currentField As String
                lrn = 1
                For Each currentField In currentRow
                    If lrn = 1 Then qval(lpn) = CSng(currentField)
                    If lrn = 2 Then hval(lpn) = CInt(currentField)
                    If lrn = 3 Then btval(lpn) = CInt(currentField)
                    If lrn = 4 Then MinTD(lpn) = CInt(currentField)
                    If lrn = 5 Then MaxTD(lpn) = CInt(currentField)
                    If lrn = 6 Then LV(lpn) = CInt(currentField)
                    If lrn = 7 Then rr(lpn) = CSng(currentField)
                    If lrn = 8 Then icf(lpn) = CInt(currentField)
                    lrn = lrn + 1
                Next
                'MsgBox("problem " + CStr(lpn) + "  " + CStr(qval(lpn)) + " " + CStr(hval(lpn)) + " " + CStr(btval(lpn)) + " " + CStr(MinTD(lpn)) + " " + CStr(MaxTD(lpn)) + " " + CStr(Earnings(lpn)) + " " + CStr(rr(lpn)) + " " + CStr(icf(lpn)))

                np = lpn
                lpn = lpn + 1
            End While
        End Using
    End Sub

    Private Sub RunProblem()
        EndOfProblem = 0
        cn = 0
        pt = 1
        ps = 1
        q = qval(pn)
        h = hval(pn)
        bt = btval(pn)
        X(1, 1) = icf(pn)
        CurrentCF(1, 1) = icf(pn)
        CalculateCashFlows()
        CalculateProbabilities()
        BuildTree()
        InsertButtons()
        InsertCashFlows()
        InsertProbabilities()
        WriteInstructions()
        Instructions.Visible = True
        ConfirmButton.Visible = False
        ConfirmButton.Text = "Click to Confirm"
        If ((pn = 1) And (EndStart = 0)) Then
            WriteInstructionsBeforeStart()
            ConfirmStartButton.Visible = True
            DeleteBox()
        End If
        If ((pn > 1) Or ((pn = 1) And (EndStart = 1))) Then
            Timer.Enabled = True
            SecondsLeft = MaxTD(pn)
        End If
        Information2.Text = "This is the start of a new problem. The jump size is " + CStr(hval(pn)) + ", the probability of moving up is " + CStr(qval(pn)) + ", the disposal value is " + CStr(LV(pn)) + " and the interest rate is " + CStr(CInt(100 * (rr(pn) - 1))) + "%."
        Information.Text = "If you dispose of the asset now, the value of the disposal will be " + CStr(Math.Round(LV(pn) * (rr(pn) ^ (bt - pt)))) + " points. The cash flows that you have gained until now are equal to " + CStr(CurrentCF(pt, ps)) + " points."
    End Sub

    Private Sub SetParameters()
        Readvsandhs()
        hb = 20.0 * vs
        wb = 12.5 * hs       'changed 27/5/2014
        'wb = 11.5 * hs   'changed 26/5/2014
        'wb = 10.0 * hs
        w1 = 10 * hs
        w0 = 0.7 * hs
        h0 = 1 * vs
        X(1, 1) = 10
        CurrentCF(1, 1) = 10
        p(1, 1) = 1
        vg = 0.005 * hb
        hg = 0.001 * wb
        sgap = 0.025 * (hb / 10)
        WidthButton = wb / 10
        HeightButton = hb / 10
        StopDecision = 0
        ContinueDecision = 0
        ConfirmDecision = 0
        pt = 1
        ps = 1
        t = 1
        s = 1
        m = 0
        Timer.Interval = 1000
    End Sub

    Private Sub StartExperiment()
        SetParameters()
        BuildInputDataBox()
    End Sub

    Private Sub StopProblem()
        ConfirmDecision = 0
        cn = cn + 1
        clicks(pn, cn) = 2
        numcl(pn) = cn
        times(pn, cn) = TotalTime
        ConfirmButton.Visible = True
        StopDecision = 1
        ContinueDecision = 0
    End Sub

    Private Sub Timer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer.Tick
        If t = 1 Then Information2.Text = "This is the start of a new problem"
        SecondsLeft = SecondsLeft - 1
        TimeLeft.Text = CStr(SecondsLeft) + " seconds left"

        If SecondsLeft > MaxTD(pn) - MinTD(pn) Then
            ContinueButton.Visible = False
            StopButton.Visible = False
            ConfirmButton.Visible = False
        End If

        If ((SecondsLeft > 0) And (SecondsLeft <= MaxTD(pn) - MinTD(pn))) Then
            StopButton.Visible = True
            ContinueButton.Visible = True
        End If

        If SecondsLeft <= 0 And pt < bt And ConfirmDecision = 0 Then
            Timer.Enabled = False
        End If
        If SecondsLeft <= 0 And pt < bt And ConfirmDecision = 0 Then
            If ((SecondsLeft < 1) And (SecondsLeft > -1)) Then MsgBox("Time is up", , "Care")
            ContinueDecision = 1
            ConfirmDecision = 1
            StopDecision = 0
            Confirm()
            ConfirmDecision = 0
            ContinueButton.Visible = False
            StopButton.Visible = False
            TimeLeft.Text = CStr(MaxTD(pn)) + " seconds left"
        End If
    End Sub

    Private Sub WriteInstructions()
        Instructions = New Label
        Instructions.Left = w0 * 1.1
        Instructions.Top = h0
        Instructions.Width = 0.42 * wb   'changed 27/5/2013
        'Instructions.Width = 0.55 * wb   'changed 26/5/2013
        'Instructions.Width = 0.6 * wb
        Instructions.Height = 1.21 * hb  'changed 26/5/2013
        'Instructions.Height = 1.8 * hb
        Me.Instructions.Font = New System.Drawing.Font("", 0.006 * hs * vs)
        Instructions.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(Instructions)
        Instructions.Text = "Summary of Instructions" & vbNewLine & " " & vbNewLine & "You will be presented with a sequence of 15 different problems. In each problem you start owning some asset which you have to dispose of during or at the end of the problem. It has a value (which may be negative). When you dispose of it, the value will earn interest until the end of the problem, and this will constitute part of your payoff for that problem. In each problem there is a sequence of time periods and you can dispose of the asset in any of these. In each of the time periods until you dispose of the asset you will also earn a cash flow (which could be positive or negative) and which will be added to (or subtracted from if it is negative) your payoff from the disposal. The cash flow follows a random path, determined by Nature, jumping either up or down by a fixed specified amount each period with specified and fixed probabilities. The disposal decision can be taken in any one of the periods of the problem, though you will have to dispose of it in the final period if you have not disposed of it before then. More specifically, your task is to decide in each time period in each of the problems whether you want to continue holding the asset to the next period of the problem, or whether you want to stop and dispose of the asset in that period. You will be given the following information in each problem: the value of the asset on disposal, the initial cash flow, the size of the jump in the cash flow, the probability that the cash flow jumps up (and the residual probability that the cash flows move down), the number of periods in the problem at the end of which you have to dispose of it, and the rate of interest on the disposal value. "
        '  Instructions.TextAlign = ContentAlignment.TopLeft
        Instructions.Visible = True
    End Sub
    Private Sub WriteInstructionsBeforeStart()
        InstructionsBeforeStart = New Label
        InstructionsBeforeStart.Left = w0 * 1.1
        InstructionsBeforeStart.Top = h0
        InstructionsBeforeStart.Width = 0.42 * wb   'changed 27/5/2013
        'InstructionsBeforeStart.Width = 0.6 * wb
        InstructionsBeforeStart.Height = 1.21 * hb  'changed 27/5/2013
        'Instructionsbeforestart.Height = 1.8 * hb
        Me.InstructionsBeforeStart.Font = New System.Drawing.Font("", 0.006 * hs * vs)
        InstructionsBeforeStart.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(InstructionsBeforeStart)
        InstructionsBeforeStart.Text = "Summary of Instructions" & vbNewLine & " " & vbNewLine & "You will be presented with a sequence of 15 different problems. In each problem you start owning some asset which you have to dispose of during or at the end of the problem. It has a value (which may be negative). When you dispose of it, the value will earn interest until the end of the problem, and this will constitute part of your payoff for that problem. In each problem there is a sequence of time periods and you can dispose of the asset in any of these. In each of the time periods until you dispose of the asset you will also earn a cash flow (which could be positive or negative) and which will be added to (or subtracted from if it is negative) your payoff from the disposal. The cash flow follows a random path, determined by Nature, jumping either up or down by a fixed specified amount each period with specified and fixed probabilities. The disposal decision can be taken in any one of the periods of the problem, though you will have to dispose of it in the final period if you have not disposed of it before then. More specifically, your task is to decide in each time period in each of the problems whether you want to continue holding the asset to the next period of the problem, or whether you want to stop and dispose of the asset in that period. You will be given the following information in each problem: the value of the asset on disposal, the initial cash flow, the size of the jump in the cash flow, the probability that the cash flow jumps up (and the residual probability that the cash flows move down), the number of periods in the problem at the end of which you have to dispose of it, and the rate of interest on the disposal value. "
        InstructionsBeforeStart.Visible = True
    End Sub
    Private Sub WriteOutput()
        'Where you are running the program from is called DirPath
        Dim Output As String
        Dim OutputFile As String
        OutputFile = DirPath + "\output data\output "
        If CInt(SubjectNumber) < 10 Then OutputFile = OutputFile + CStr(InputFileNumber) + " 00" + CStr(SubjectNumber) + ".txt"
        If ((CInt(SubjectNumber) > 9) And (CInt(SubjectNumber < 100))) Then OutputFile = OutputFile + CStr(InputFileNumber) + " 0" + CStr(SubjectNumber) + ".txt"
        If CInt(SubjectNumber) > 99 Then OutputFile = OutputFile + CStr(InputFileNumber) + " " + CStr(SubjectNumber) + ".txt"
        Dim OutputWriter As New System.IO.StreamWriter(OutputFile, append:=False)
        OutputWriter.WriteLine("Subject Number " + CStr(SubjectNumber) + "    Input File " + CStr(InputFileNumber))
        OutputWriter.WriteLine("")
        OutputWriter.WriteLine("ProblemNumber  ClickNumber StoppingPeriod TimeOf Click TypeofClick")

        pn = 1
        Do While pn <= np
            cn = 1
            Do While cn <= numcl(pn)
                Output = CStr(pn) + " " + CStr(cn) + " " + CStr(stopp(pn)) + " " + CStr(times(pn, cn)) + " " + CStr(clicks(pn, cn))
                OutputWriter.WriteLine(Output)
                cn = cn + 1
            Loop
            pn = pn + 1
        Loop
        OutputWriter.Close()

        Dim Earning As String
        Dim EarningsFile As String
        EarningsFile = DirPath + "\earnings data\"
        If CInt(SubjectNumber) < 10 Then EarningsFile = EarningsFile + CStr(InputFileNumber) + " 00" + CStr(SubjectNumber) + ".txt"
        If ((CInt(SubjectNumber) > 9) And (CInt(SubjectNumber < 100))) Then EarningsFile = EarningsFile + CStr(InputFileNumber) + " 0" + CStr(SubjectNumber) + ".txt"
        If CInt(SubjectNumber) > 99 Then EarningsFile = EarningsFile + CStr(InputFileNumber) + " " + CStr(SubjectNumber) + ".txt"
        Dim EarningsWriter As New System.IO.StreamWriter(EarningsFile, append:=False)
        EarningsWriter.WriteLine("Subject Number " + CStr(SubjectNumber) + "    Input File " + CStr(InputFileNumber))
        EarningsWriter.WriteLine("")
        EarningsWriter.WriteLine("Problem  Earnings")

        pn = 1
        Do While pn <= np
            Earning = ""
            If pn < 10 Then Earning = CStr(pn) + "        " + CStr(Earnings(pn))
            If ((pn > 9) And (pn < 100)) Then Earning = CStr(pn) + "       " + CStr(Earnings(pn))
            If pn > 99 Then Earning = CStr(pn) + "   " + CStr(Earnings(pn))
            EarningsWriter.WriteLine(Earning)
            pn = pn + 1
        Loop
        EarningsWriter.Close()

        Dim Nature As String
        Dim NatureFile As String
        NatureFile = DirPath + "\nature data\nature "
        If CInt(SubjectNumber) < 10 Then NatureFile = NatureFile + CStr(InputFileNumber) + " 00" + CStr(SubjectNumber) + ".txt"
        If ((CInt(SubjectNumber) > 9) And (CInt(SubjectNumber < 100))) Then NatureFile = NatureFile + CStr(InputFileNumber) + " 0" + CStr(SubjectNumber) + ".txt"
        If CInt(SubjectNumber) > 99 Then NatureFile = NatureFile + CStr(InputFileNumber) + " " + CStr(SubjectNumber) + ".txt"
        Dim NatureWriter As New System.IO.StreamWriter(NatureFile, append:=False)
        NatureWriter.WriteLine("Subject Number " + CStr(SubjectNumber) + "    Input File " + CStr(InputFileNumber))
        NatureWriter.WriteLine("")
        NatureWriter.WriteLine("ProblemNumber  Period NaturesMove NextCashFlow")

        pn = 1
        Do While pn <= np
            pt = 1
            Do While pt <= 20
                If NaturesMoves(pn, pt) > 0 Then
                    Nature = CStr(pn) + " " + CStr(pt) + " " + CStr(NaturesMoves(pn, pt)) + " " + CStr(NextCashFlow(pn, pt))
                    NatureWriter.WriteLine(Nature)
                End If
                pt = pt + 1
            Loop
            pn = pn + 1
        Loop
        NatureWriter.Close()


    End Sub

    Private Sub TotalTimer_Tick(sender As Object, e As EventArgs) Handles TotalTimer.Tick
        TotalTime = TotalTime + 1
    End Sub


    WithEvents PrintDocument As New PrintDocument()
    Dim stringToPrint As String

    Private Sub PrintFile()

        ReadFile()
        PrintDocument.Print()
    End Sub
    Dim EarningsFile As String
    Private Sub ReadFile()
        If CInt(SubjectNumber) < 10 Then EarningsFile = DirPath + "\earnings data\" + CStr(InputFileNumber) + " 00" + CStr(SubjectNumber) + ".txt"
        If ((CInt(SubjectNumber) > 9) And (CInt(SubjectNumber) < 100)) Then EarningsFile = DirPath + "\earnings data\" + CStr(InputFileNumber) + " 0" + CStr(SubjectNumber) + ".txt"
        If CInt(SubjectNumber) > 99 Then EarningsFile = DirPath + "\earnings data\" + CStr(InputFileNumber) + " " + CStr(SubjectNumber) + ".txt"
        PrintDocument.DocumentName = EarningsFile
        Dim stream As New FileStream(EarningsFile, FileMode.Open)
        Try
            Dim reader As New StreamReader(stream)
            Try
                stringToPrint = reader.ReadToEnd()
            Finally
                reader.Dispose()
            End Try
        Finally
            stream.Dispose()
        End Try
    End Sub

    Private Sub printDocument_PrintPage(ByVal sender As Object, ByVal e As PrintPageEventArgs) Handles PrintDocument.PrintPage

        Dim charactersOnPage As Integer = 0
        Dim linesPerPage As Integer = 0

        ' Sets the value of charactersOnPage to the number of characters  
        ' of stringToPrint that will fit within the bounds of the page.
        e.Graphics.MeasureString(stringToPrint, Me.Font, e.MarginBounds.Size, _
            StringFormat.GenericTypographic, charactersOnPage, linesPerPage)

        ' Draws the string within the bounds of the page
        e.Graphics.DrawString(stringToPrint, Me.Font, Brushes.Black, _
            e.MarginBounds, StringFormat.GenericTypographic)

        ' Remove the portion of the string that has been printed.
        stringToPrint = stringToPrint.Substring(charactersOnPage)

        ' Check to see if more pages are to be printed.
        e.HasMorePages = stringToPrint.Length > 0

    End Sub


End Class
